﻿using System;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Custom.EFR
{
    public partial class EfrMaster : MasterPage
    {
        private const string AntiXsrfTokenKey = "__AntiXsrfToken";
        private const string AntiXsrfUserNameKey = "__AntiXsrfUserName";
        private string antiXsrfTokenValue;

        private ApplicationSession applicationSession;
        private UserSession userSession;

        protected ApplicationSession ApplicationSession
        {
            get
            {
                if (Application["ApplicationSession"] != null)
                {
                    applicationSession = (ApplicationSession)Application["ApplicationSession"];
                }

                if (applicationSession == null) applicationSession = new ApplicationSession();

                return applicationSession;
            }
            set
            {
                applicationSession = value;
            }
        }

        protected UserSession UserSession
        {
            get
            {
                if (Session["UserSession"] != null)
                {
                    userSession = (UserSession)Session["UserSession"];
                }

                if (userSession == null) userSession = new UserSession();

                return userSession;
            }
            set
            {
                userSession = value;
            }
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            // The code below helps to protect against XSRF attacks
            var requestCookie = Request.Cookies[AntiXsrfTokenKey];
            Guid requestCookieGuidValue;
            if (requestCookie != null && Guid.TryParse(requestCookie.Value, out requestCookieGuidValue))
            {
                // Use the Anti-XSRF token from the cookie
                antiXsrfTokenValue = requestCookie.Value;
                Page.ViewStateUserKey = antiXsrfTokenValue;
            }
            else
            {
                // Generate a new Anti-XSRF token and save to the cookie
                antiXsrfTokenValue = Guid.NewGuid().ToString("N");
                Page.ViewStateUserKey = antiXsrfTokenValue;

                var responseCookie = new HttpCookie(AntiXsrfTokenKey)
                {
                    HttpOnly = true,
                    Value = antiXsrfTokenValue
                };
                if (FormsAuthentication.RequireSSL && Request.IsSecureConnection)
                {
                    responseCookie.Secure = true;
                }
                Response.Cookies.Set(responseCookie);
            }

            Page.PreLoad += Master_Page_PreLoad;
        }

        protected void Master_Page_PreLoad(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // Set Anti-XSRF token
                ViewState[AntiXsrfTokenKey] = Page.ViewStateUserKey;
                ViewState[AntiXsrfUserNameKey] = Context.User.Identity.Name ?? String.Empty;
            }
            else
            {
                // Validate the Anti-XSRF token
                if ((string)ViewState[AntiXsrfTokenKey] != antiXsrfTokenValue
                    || (string)ViewState[AntiXsrfUserNameKey] != (Context.User.Identity.Name ?? String.Empty))
                {
                    throw new InvalidOperationException("Validation of Anti-XSRF token failed.");
                }
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                if (!Page.IsPostBack)
                {
                    //mnuLeftMenu.MenuItemDataBound += MnuLeftMenu_MenuItemDataBound;

                    BuildMenu();

                    string buildVersion = ServiceInterfaceManager.GET_VERSION();

                    lblVersion.Text = "VIRP Version: " + AntiXssEnc.Encoder.HtmlEncode(buildVersion);

                    AppSettings settings = ServiceInterfaceManager.APPSETTINGS_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    if (settings != null)
                    {
                        if (!string.IsNullOrEmpty(settings.SSOiLogoutUrl))
                        {
                            linkSSOiLogout.Visible = true;
                            linkSSOiLogout.NavigateUrl = AntiXssEnc.Encoder.HtmlEncode(settings.SSOiLogoutUrl).Replace("&amp;amp;", "&").Replace("&amp;", "&").Replace("amp;", "&");
                        }
                    }

                    foreach (MenuItem mi in mnuTopMenu.Items)
                    {
                        if (mi.Text == "Help")
                        {
                            int end = 0;
                            string helpPageUrl = "";

                            end = HttpContext.Current.Request.Url.AbsoluteUri.LastIndexOf("aspx");
                            
                            helpPageUrl = "~/Custom/EFR/Help" +
                                HttpContext.Current.Request.Url.AbsoluteUri.Substring(
                                    HttpContext.Current.Request.Url.AbsoluteUri.LastIndexOf("/"),
                                    end - HttpContext.Current.Request.Url.AbsoluteUri.LastIndexOf("/")) +
                                    "html";

                            mi.NavigateUrl = helpPageUrl;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw ex;
            }
        }

        public void BuildMenu()
        {
            try
            {
                dsLeftMenu.Data = GetLeftMenuXml();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, 0);
                throw ex;
            }
        }

        private static string GetLeftMenuXml()
        {
            string xml = @"
            <?xml version='1.0' encoding='utf-16'?>
            <CrsMenu xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xsd='http://www.w3.org/2001/XMLSchema'>
            <MenuItems>
            <CrsMenuItem DisplayText='Embedded Fragment Registry' NavigateUrl='' Selectable='false' />
            <CrsMenuItem DisplayText='Registry Home' NavigateUrl='~/Custom/EFR/Default.aspx' Selectable='true' />
            <CrsMenuItem DisplayText='Referrals: New' NavigateUrl='~/Custom/EFR/Referrals/Referrals.aspx?statusId=4' Selectable='true' />
            <CrsMenuItem DisplayText='Referrals: Open' NavigateUrl='~/Custom/EFR/Referrals/Referrals.aspx?statusId=5' Selectable='true' />
            <CrsMenuItem DisplayText='Referrals: Closed' NavigateUrl='~/Custom/EFR/Referrals/Referrals.aspx?statusId=6' Selectable='true' />
            <CrsMenuItem DisplayText='Referrals: Follow Ups' NavigateUrl='~/Custom/EFR/Referrals/BioContactFollowUps.aspx' Selectable='true' />
            <CrsMenuItem DisplayText='Referrals: Ineligible' NavigateUrl='~/Custom/EFR/Referrals/Referrals.aspx?statusId=9' Selectable='true' /> 
            <CrsMenuItem DisplayText='Lab Kits: New' NavigateUrl='~/Custom/EFR/LabKits/LabKitOrders.aspx' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Kits: Tracking' NavigateUrl='~/Custom/EFR/LabKits/LabKitInProcessOrders.aspx?OrderType=4' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Kits: Received' NavigateUrl='~/Custom/EFR/LabKits/LabKitInProcessOrders.aspx?OrderType=5' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Kits: Voided' NavigateUrl='~/Custom/EFR/LabKits/LabKitInProcessOrders.aspx?OrderType=3' Selectable='true' />
            <CrsMenuItem DisplayText='Questionnaires: New' NavigateUrl='~/Custom/EFR/Questionnaires/Surveys.aspx?statusId=6' Selectable='true' />
            <CrsMenuItem DisplayText='Questionnaires: In Process' NavigateUrl='~/Custom/EFR/Questionnaires/Surveys.aspx?statusId=1' Selectable='true' />
            <CrsMenuItem DisplayText='Questionnaires: Completed' NavigateUrl='~/Custom/EFR/Questionnaires/Surveys.aspx?statusId=2' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Orders: New ' NavigateUrl='~/Custom/EFR/LabOrders/LabOrders.aspx?statusId=6' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Orders: Awaiting Results' NavigateUrl='~/Custom/EFR/LabOrders/LabOrders.aspx?statusId=11' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Orders: Voided' NavigateUrl='~/Custom/EFR/LabOrders/LabOrders.aspx?statusId=3' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Orders: Closed' NavigateUrl='~/Custom/EFR/LabOrders/LabOrders.aspx?statusId=9' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Results: New' NavigateUrl='~/Custom/EFR/LabResults/LabResults.aspx?OrderType=6' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Results: In Process' NavigateUrl='~/Custom/EFR/LabResults/LabResults.aspx?OrderType=1' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Results: Accepted' NavigateUrl='~/Custom/EFR/LabResults/LabResults.aspx?OrderType=7' Selectable='true' />
            <CrsMenuItem DisplayText='Lab Results: Voided' NavigateUrl='~/Custom/EFR/LabResults/LabResults.aspx?OrderType=3' Selectable='true' />
            <CrsMenuItem DisplayText='Interpretation &amp; Follow Up: New' NavigateUrl='~/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx?OrderType=6' Selectable='true' />
            <CrsMenuItem DisplayText='Interpretation &amp; Follow Up: In Process' NavigateUrl='~/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx?OrderType=1' Selectable='true' />
            <CrsMenuItem DisplayText='Interpretation &amp; Follow Up: Interpreted' NavigateUrl='~/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx?OrderType=10' Selectable='true' />
            <CrsMenuItem DisplayText='Contact Logs: All Contacts' NavigateUrl='~/Custom/EFR/Referrals/ReferralContactLogs.aspx' Selectable='true' />
            <CrsMenuItem DisplayText='Data Exports' NavigateUrl='~/Custom/EFR/DataExports/Default.aspx' Selectable='true' />
            </MenuItems>
            </CrsMenu>";

            return xml;
        }

        protected void ListRegistries_DataBound(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                listRegistries.Items.Insert(0, new ListItem("Select...", "0"));
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void ListRegistries_SelectedIndexChanged(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                int id = 0;
                int.TryParse(listRegistries.SelectedValue, out id);

                if (id > 0)
                {
                    UserSession.CurrentRegistryId = id;
                    Response.Redirect("~/Common/Default.aspx?id=" + UserSession.CurrentRegistryId, false);
                }
                else
                {
                    UserSession.CurrentRegistryId = 0;
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void DsRegistries_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                e.InputParameters.Clear();
                e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);
                e.InputParameters.Add("CURRENT_REGISTRY_ID", 0);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        //private void MnuLeftMenu_MenuItemDataBound(object sender, MenuEventArgs e)
        //{
        //    ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

        //    try
        //    {
        //        string[] disableMenus = new string[] { "Cohort Criteria", "Framework Data", "User-Defined Fields", "Work Streams", "Activities" };

        //        bool selectable = UserSession.CurrentRegistryId > 0;
        //        foreach (var mnu in mnuLeftMenu.Items)
        //        {
        //            MenuItem mnuItem = (MenuItem)mnu;
        //            if (disableMenus.ToList().FindIndex(x => x.Equals(mnuItem.Text)) > -1)
        //            {
        //                mnuItem.Selectable = selectable;
        //            }
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
        //        throw ex;
        //    }
        //}
    }
}